// Script header for module 'EpicShadow'

// Original module 'Shadow' Author: Andrew MacCormack (SSH)

// Some changes by Dario 'Dusk' Scarpa 
// made for "Star Wars: Shadows of the Empire - Graphic Adventure"
//           by Hexence - http://www.hexence.com
 
// Abstract: Make a circular shadow underneath characters.
//
// Dependencies:
//
//   AGS 3.0.2 or later

/*
  What did I change from the original 'Shadow' module by SSH?

The wonderful thing of the original Shadow module was that you just had to
import it and all your characters had cleverly drawn shadows 
(with caching, scaling and depending on character dimensions).
By the way it had some major issues, pointed by the author itself:

-   Animated background frames mess it up.
-   Walkbehinds don't work on the shadow.

I managed to solve these issues drawing shadows to a DynamicSprite and 
assigning it to a "dummy object".
Walkbehinds and animated backgrounds work (shadows are by default drawn
behind other stuff, the dummy object is set with Baseline 1), but the 
drawback is that you have to put an object in every room where
you want shadows to make the module work.

So, if you don't have walkbehinds or animated backgrounds, go for the
original module. :)
If you have them, placing the dummy object in each room is boring, but
less boring and more functional (IMHO) that the other approaches to the
problem (like the one of the dummy shadow character with Follow_Exactly...
if you can have 5 characters in a room).

I did also another minor change: I scaled the shadow respect to the Character.Z.
I needed this with a flying character, to make the shadow gradually disappear
when he starts to float and gradually appear when he approaches the ground. 

Another little improvement is the Shadow.SetScale function, to adjust the
dynamically calculated width of the shadow on a per character basis.

Warning: having a room-wide dynamic sprite was SLOW, so I optimized a bit 
letting you define the "shadowable area" of a room when you put the
"dummy object". 
In short, drag it such that its Y is above the walkable areas: no shadows 
will be drawn above it.

This should work in the most common case of the walkable areas in the lower
part of the screen...
if you're coding a SpiderMan adventure and he walks on the ceiling, you might
need to change some lines of code to have better performances :)

The module scans for an object called "ModShadows" when you enter a room.
If he finds it, he creates the sprite and draws the shadows. If he doesn't,
nothing is done.

Letting the user disable shadows to have better performances is reasonable,
maybe from a "game settings" GUI, so you can toggle the feature on/off
with Shadow.SetActive(bool trueFalse). If you call Shadow.SetActive(false),
the "ModShadows" objects will be ignored (and made invisible, of course) and
no shadows will be drawn.

Other features should work exactly as in the original module.

Thankyou SSH!

  Dusk
*/

//
// Functions:
//
//  function eShadow.SetActive(bool yesNo);
//
//    Enables/disables the module. Default is enabled.
//
//  function eShadow.SetPerspective(float factor);
//
//		Set the perspective factor of the circle. The default is for the
//    height of the circle to be 0.15 times the width
//
//  function eShadow.Disable(Character *who); 
//
//		Turn off the shadow for the specified character.
//
//  function eShadow.Enable(Character *who);
//
//		Turn on the shadow for the specified character.
//
//  function eShadow.SetOffset(Character *who, optional int y, optional int x);
//
//		Set the y and x offset for the specified character, for example 
//    if they generally have a lot of blank space around the edge of 
//		their frames. Default offsets are 0. If you pass only 1 parameter, the
//    x offset is assumed to be 0, which is usually right.
//
//  function eShadow.SetScale(Character *who, int xScalePercent);
//
//    Alters the width of the specified character shadow.
//    By default, each character shadow has 100% value.
//    Sometimes you have sprites that project a too wide shadow, and you
//    can adjust it here for each single character.
//
//  function eShadow.SetRGB(int red, int green, int blue);
//
//		Set the colour of the shadow. NB pure black shadows (0,0,0) do not
//    become transparent, so the default is (35, 35, 35).
//
//  function eShadow.SetTransparency(int percent);
//
//		Set the transparency level for the shadow. Default is 80%
//
//
// Configuration:
//  Put an object in a room where you want to have shadows and call it "ModShadows".
//  Place it such that its Y coordinate is just above the walkable part of the room:
//   no shadows will be drawn above the Y coordinate of the "ModShadows" object.
//  By default, all characters in the current room will have shadows.
//
// Caveats:
//
//   This may be SLOW if you have very large rooms, try to place the "ModShadows"
//    dummy object such that its Y is not too far from the room lower edge.
//
// Revision History:
// 14 Aug 08: v1.0  First release of EpicShadow module by Dusk
// 31 Oct 06: v1.0  First release of Shadow module by SSH
//
// Licence:
//
//   EpicShadows/Shadow AGS script module
//   Copyright (C) 2008 Dario Scarpa
//   Copyright (C) 2006 Andrew MacCormack
//
// This module is licenced under the Creative Commons Attribution Share-alike
// licence, (see http://creativecommons.org/licenses/by-sa/2.5/scotland/ )
// which basically means do what you like as long as you credit me and don't
// start selling modified copies of this module.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.

#define EPICSHADOWS_MAX_WIDTH 200

// waiting for dynamic arrays in struct support...
// you can put the number of characters you have in your game here
#define EPICSHADOWS_MAX_CHARACTERS 300

struct EpicShadows {

/* // no dynamic arrays inside structs for now :( 
	int lastx[];
	protected int lasty[];
  protected int lasth[];
  protected int lastw[];
  protected DynamicSprite* lasts[];
  
  writeprotected int offsetx[];
	writeprotected int offsety[];
  writeprotected bool off[];  
*/
  protected bool active;
  
  protected DynamicSprite *lasts[EPICSHADOWS_MAX_CHARACTERS];
	protected int lastx[EPICSHADOWS_MAX_CHARACTERS];
	protected int lasty[EPICSHADOWS_MAX_CHARACTERS];
  protected int lasth[EPICSHADOWS_MAX_CHARACTERS];
  protected int lastw[EPICSHADOWS_MAX_CHARACTERS];
 
  protected DynamicSprite *cache[EPICSHADOWS_MAX_WIDTH];
  import function generate_cache();
  import function rep_ex();
  import function newroom();
  import function reset();
  
  protected DynamicSprite *shadowsCanvas;
  protected Object *oShadows;
  import function exitroom(); 

	writeprotected float PerspectiveFactor;
  writeprotected int Red;
  writeprotected int Green;
  writeprotected int Blue;
  writeprotected int Transparency;
	
	writeprotected int offsetx[EPICSHADOWS_MAX_CHARACTERS];
	writeprotected int offsety[EPICSHADOWS_MAX_CHARACTERS];
  writeprotected bool off[EPICSHADOWS_MAX_CHARACTERS];
  writeprotected int scalex[EPICSHADOWS_MAX_CHARACTERS];
  
  import function setShadowsObject();
  import function SetActive(bool yesNo);
  import function SetPerspective(float factor);
  import function Disable(Character *who); 
  import function Enable(Character *who);
  import function SetOffset(Character *who, int y=0, int x=0);
  import function SetScale(Character *who, int xScalePercent);
  import function SetRGB(int red, int green, int blue);
  import function SetTransparency(int percent);
};

import EpicShadows eShadow;
