AGSScriptModule    SSH & Dusk Let all your characters have a shadow. EpicShadow 1.0 y  // Main script for module 'EpicShadow'

bool first_room;
int offsetY; // to save and restore the ModShadows object Y pos, 
             //and calculate where to draw

EpicShadows eShadow;
export eShadow;



function EpicShadows::generate_cache() { //great idea, SSH!
	int i=1;
  while (i<EPICSHADOWS_MAX_WIDTH) {
    if (this.cache[i]!=null) this.cache[i].Delete(); // Clear old cache
    
    this.cache[i] = DynamicSprite.Create(i, i);
    DrawingSurface *surface = this.cache[i].GetDrawingSurface();
        
    // Draw circle in shadow colour and grab sprite
    surface.DrawingColor = Game.GetColorFromRGB(this.Red, this.Green, this.Blue);
    int half=i/2;
    surface.DrawCircle(half, half, half);
    
    surface.Release();
    
    // Now squash circle to ellipse. Shame drawcircle doesn't have an optional ellipse thingy 
    int height=FloatToInt(this.PerspectiveFactor*IntToFloat(i), eRoundUp);
    this.cache[i].Resize(i, height);
	  i++;    
	}  
}

function EpicShadows::reset () {
  this.active = true;
	this.PerspectiveFactor=0.15;
	this.Red=35;
	this.Green=35;
	this.Blue=35;

  int i = 0;
  while (i<Game.CharacterCount) {
			this.scalex[i]=100;
			i++;
  }

/*// someday ...
  this.lasts = new DynamicSprite*[Game.CharacterCount];
  this.lastx = new int[Game.CharacterCount];
  this.lasty = new int[Game.CharacterCount];
  this.lasth = new int[Game.CharacterCount];
  this.lastw = new int[Game.CharacterCount];
  
  this.offsetx = new int[Game.CharacterCount];
  this.offsety = new int[Game.CharacterCount];
  this.off = new boolean[Game.CharacterCount];	
*/
}


function game_start() {
  eShadow.reset();
    
  first_room=true;
}

function EpicShadows::setShadowsObject() {
  int i = 0;
  bool found = false; 
  while (i<Room.ObjectCount && !found) {
      if (object[i].Name == "ModShadows") {
          found = true;
          this.oShadows = object[i];
      }
      i++;
  } 
  return found;
}
function EpicShadows::newroom() {    
    if (!this.setShadowsObject()) return;
    
    if (!this.active) {
        this.oShadows.Visible = false;
        return;
    }
       
    int i=0;
    while (i<Game.CharacterCount) {
			this.lasts[i]=null;
			i++;
    }
    
    //this.oShadows = object[i];
    this.oShadows.Transparency = this.Transparency;
    this.oShadows.Clickable = false;          
  //put shadows behind other stuff 
    this.oShadows.Baseline = 1;  
    
  //define the "shadow area" dynamic sprite
    //this.oShadows.SetPosition(0, Room.Height);          
    //this.shadowsCanvas = DynamicSprite.Create(Room.Width, Room.Height); 
    //...this was simple but slow :(
         
    //this.shadowsCanvas = DynamicSprite.Create(Room.Width, Room.Height-this.oShadows.Y);          
    //...we can do better horizontally
          
    // create large as the viewport and not the room, and then move accordingly the object in rep_exec
    this.shadowsCanvas = DynamicSprite.Create(System.ViewportWidth, Room.Height-this.oShadows.Y);
    offsetY = this.oShadows.Y; // save Y offset 
    this.oShadows.Y = Room.Height; // put object down                    
    this.oShadows.X = GetViewportX(); //put object on the left edge of the viewport
    //this.oShadows.X = 0; //put object on the left edge of the room    
    this.oShadows.Visible = true;
}

function EpicShadows::exitroom() {
  if (this.oShadows != null) {
    if (this.shadowsCanvas != null)
      this.shadowsCanvas.Delete(); 
    this.oShadows.Y = offsetY; // restore the Y pos of the dummy object
    this.oShadows.Visible = false;
    this.oShadows = null;    
  }
}
function on_event(EventType event, int data) {
  if (event==eEventEnterRoomBeforeFadein) {
    eShadow.newroom();
    if (first_room) {
			eShadow.generate_cache(); // Cannot run in game_start, there's nowhere to draw
			first_room=false;
		}
	} else if (event == eEventLeaveRoom) {
    eShadow.exitroom();
  }
}


function EpicShadows::rep_ex() {
    if ( (!this.active) || (this.oShadows == null)/* || (this.shadowsCanvas == null)*/ ) return;
    DrawingSurface *sSurface = this.shadowsCanvas.GetDrawingSurface();
    sSurface.Clear();
    
    int i=0;
    
    while (i<Game.CharacterCount) {
      if (player.Room==character[i].Room && character[i].on && !this.off[i]) {
        Character *cs=character[i];
        ViewFrame *vf=Game.GetViewFrame(cs.View, cs.Loop, cs.Frame);
        int scale=GetScalingAt(cs.x, cs.y);
        scale -= cs.z*3;
        if (scale > 0) {
          //if (cs.z >0) scale =  (10-player.z); //((scale * 10)/cs.z) / 10;
          int width=(Game.SpriteWidth[vf.Graphic]*scale)/100;
          width = ( width * this.scalex[i] ) / 100;
          if (width==0) width=1;
          int height=FloatToInt(this.PerspectiveFactor*IntToFloat(width), eRoundUp);
          int half=width/2;
          int halfh=height/2;
          this.lastx[i]=cs.x-half+((this.offsetx[i]*scale)/100);
          this.lasty[i]=(cs.y-halfh)+((this.offsety[i]*scale)/100);
          if (this.lastx[i]<0) this.lastx[i]=0;
          if (this.lasty[i]<0) this.lasty[i]=0;
          if (this.lastx[i]+width>Room.Width) width=Room.Width-this.lastx[i];
          if (this.lasty[i]+height>Room.Height) height=Room.Height-this.lasty[i];
          this.lastw[i]=width;
          this.lasth[i]=height;
          //sSurface.DrawImage(this.lastx[i], this.lasty[i], this.cache[width].Graphic);
          sSurface.DrawImage(this.lastx[i]-GetViewportX(), this.lasty[i]-offsetY, this.cache[width].Graphic);
        }
      }
      i++;       // Next character
    }
    this.oShadows.X = GetViewportX(); //let the shadows area follow the scrolling
    this.oShadows.Graphic = this.shadowsCanvas.Graphic;    
    sSurface.Release();
}    

function repeatedly_execute_always() {  
  eShadow.rep_ex();
}

function EpicShadows::SetPerspective(float factor) {
  this.PerspectiveFactor=factor;
  // Remake cache, as long as we're not in game_start:
  if (!first_room) this.generate_cache(); 
}

function EpicShadows::Disable(Character *who) {
  this.off[who.ID]=true;
}

function EpicShadows::Enable(Character *who) {
  this.off[who.ID]=false;
}

function EpicShadows::SetOffset(Character *who, int y, int x) {
  this.offsetx[who.ID]=x;
  this.offsety[who.ID]=y;
}
function EpicShadows::SetScale(Character *who,  int xScalePercent) {
  this.scalex[who.ID] = xScalePercent;
}

function EpicShadows::SetRGB(int red, int green, int blue) {
  this.Red=red; this.Blue=blue; this.Green=green;
}

function EpicShadows::SetTransparency(int percent) {
  this.Transparency=percent;
  if (this.oShadows!= null) this.oShadows.Transparency = percent;  
}

function EpicShadows::SetActive(bool active) {
  if (this.active == active) return; //nothing to do
  this.active = active;
  if (active) {
      this.newroom();      
  } else {
      this.exitroom();      
  }
  
}   // Script header for module 'EpicShadow'

// Original module 'Shadow' Author: Andrew MacCormack (SSH)

// Some changes by Dario 'Dusk' Scarpa 
// made for "Star Wars: Shadows of the Empire - Graphic Adventure"
//           by Hexence - http://www.hexence.com
 
// Abstract: Make a circular shadow underneath characters.
//
// Dependencies:
//
//   AGS 3.0.2 or later

/*
  What did I change from the original 'Shadow' module by SSH?

The wonderful thing of the original Shadow module was that you just had to
import it and all your characters had cleverly drawn shadows 
(with caching, scaling and depending on character dimensions).
By the way it had some major issues, pointed by the author itself:

-   Animated background frames mess it up.
-   Walkbehinds don't work on the shadow.

I managed to solve these issues drawing shadows to a DynamicSprite and 
assigning it to a "dummy object".
Walkbehinds and animated backgrounds work (shadows are by default drawn
behind other stuff, the dummy object is set with Baseline 1), but the 
drawback is that you have to put an object in every room where
you want shadows to make the module work.

So, if you don't have walkbehinds or animated backgrounds, go for the
original module. :)
If you have them, placing the dummy object in each room is boring, but
less boring and more functional (IMHO) that the other approaches to the
problem (like the one of the dummy shadow character with Follow_Exactly...
if you can have 5 characters in a room).

I did also another minor change: I scaled the shadow respect to the Character.Z.
I needed this with a flying character, to make the shadow gradually disappear
when he starts to float and gradually appear when he approaches the ground. 

Another little improvement is the Shadow.SetScale function, to adjust the
dynamically calculated width of the shadow on a per character basis.

Warning: having a room-wide dynamic sprite was SLOW, so I optimized a bit 
letting you define the "shadowable area" of a room when you put the
"dummy object". 
In short, drag it such that its Y is above the walkable areas: no shadows 
will be drawn above it.

This should work in the most common case of the walkable areas in the lower
part of the screen...
if you're coding a SpiderMan adventure and he walks on the ceiling, you might
need to change some lines of code to have better performances :)

The module scans for an object called "ModShadows" when you enter a room.
If he finds it, he creates the sprite and draws the shadows. If he doesn't,
nothing is done.

Letting the user disable shadows to have better performances is reasonable,
maybe from a "game settings" GUI, so you can toggle the feature on/off
with Shadow.SetActive(bool trueFalse). If you call Shadow.SetActive(false),
the "ModShadows" objects will be ignored (and made invisible, of course) and
no shadows will be drawn.

Other features should work exactly as in the original module.

Thankyou SSH!

  Dusk
*/

//
// Functions:
//
//  function eShadow.SetActive(bool yesNo);
//
//    Enables/disables the module. Default is enabled.
//
//  function eShadow.SetPerspective(float factor);
//
//		Set the perspective factor of the circle. The default is for the
//    height of the circle to be 0.15 times the width
//
//  function eShadow.Disable(Character *who); 
//
//		Turn off the shadow for the specified character.
//
//  function eShadow.Enable(Character *who);
//
//		Turn on the shadow for the specified character.
//
//  function eShadow.SetOffset(Character *who, optional int y, optional int x);
//
//		Set the y and x offset for the specified character, for example 
//    if they generally have a lot of blank space around the edge of 
//		their frames. Default offsets are 0. If you pass only 1 parameter, the
//    x offset is assumed to be 0, which is usually right.
//
//  function eShadow.SetScale(Character *who, int xScalePercent);
//
//    Alters the width of the specified character shadow.
//    By default, each character shadow has 100% value.
//    Sometimes you have sprites that project a too wide shadow, and you
//    can adjust it here for each single character.
//
//  function eShadow.SetRGB(int red, int green, int blue);
//
//		Set the colour of the shadow. NB pure black shadows (0,0,0) do not
//    become transparent, so the default is (35, 35, 35).
//
//  function eShadow.SetTransparency(int percent);
//
//		Set the transparency level for the shadow. Default is 80%
//
//
// Configuration:
//  Put an object in a room where you want to have shadows and call it "ModShadows".
//  Place it such that its Y coordinate is just above the walkable part of the room:
//   no shadows will be drawn above the Y coordinate of the "ModShadows" object.
//  By default, all characters in the current room will have shadows.
//
// Caveats:
//
//   This may be SLOW if you have very large rooms, try to place the "ModShadows"
//    dummy object such that its Y is not too far from the room lower edge.
//
// Revision History:
// 14 Aug 08: v1.0  First release of EpicShadow module by Dusk
// 31 Oct 06: v1.0  First release of Shadow module by SSH
//
// Licence:
//
//   EpicShadows/Shadow AGS script module
//   Copyright (C) 2008 Dario Scarpa
//   Copyright (C) 2006 Andrew MacCormack
//
// This module is licenced under the Creative Commons Attribution Share-alike
// licence, (see http://creativecommons.org/licenses/by-sa/2.5/scotland/ )
// which basically means do what you like as long as you credit me and don't
// start selling modified copies of this module.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.

#define EPICSHADOWS_MAX_WIDTH 200

// waiting for dynamic arrays in struct support...
// you can put the number of characters you have in your game here
#define EPICSHADOWS_MAX_CHARACTERS 300

struct EpicShadows {

/* // no dynamic arrays inside structs for now :( 
	int lastx[];
	protected int lasty[];
  protected int lasth[];
  protected int lastw[];
  protected DynamicSprite* lasts[];
  
  writeprotected int offsetx[];
	writeprotected int offsety[];
  writeprotected bool off[];  
*/
  protected bool active;
  
  protected DynamicSprite *lasts[EPICSHADOWS_MAX_CHARACTERS];
	protected int lastx[EPICSHADOWS_MAX_CHARACTERS];
	protected int lasty[EPICSHADOWS_MAX_CHARACTERS];
  protected int lasth[EPICSHADOWS_MAX_CHARACTERS];
  protected int lastw[EPICSHADOWS_MAX_CHARACTERS];
 
  protected DynamicSprite *cache[EPICSHADOWS_MAX_WIDTH];
  import function generate_cache();
  import function rep_ex();
  import function newroom();
  import function reset();
  
  protected DynamicSprite *shadowsCanvas;
  protected Object *oShadows;
  import function exitroom(); 

	writeprotected float PerspectiveFactor;
  writeprotected int Red;
  writeprotected int Green;
  writeprotected int Blue;
  writeprotected int Transparency;
	
	writeprotected int offsetx[EPICSHADOWS_MAX_CHARACTERS];
	writeprotected int offsety[EPICSHADOWS_MAX_CHARACTERS];
  writeprotected bool off[EPICSHADOWS_MAX_CHARACTERS];
  writeprotected int scalex[EPICSHADOWS_MAX_CHARACTERS];
  
  import function setShadowsObject();
  import function SetActive(bool yesNo);
  import function SetPerspective(float factor);
  import function Disable(Character *who); 
  import function Enable(Character *who);
  import function SetOffset(Character *who, int y=0, int x=0);
  import function SetScale(Character *who, int xScalePercent);
  import function SetRGB(int red, int green, int blue);
  import function SetTransparency(int percent);
};

import EpicShadows eShadow;
 +0        ej